﻿using System;
using System.Numerics;
using System.Reflection;

namespace Arrays
{
    class Examples1_5
    {
        public static void CreateAndUseArray()
        {
            // Listing 5-1
            int[] numbers = new int[10];
            string[] strings = new string[numbers.Length];

            // Listing 5-2
            // Kontynuacja listingu 5-1
            numbers[0] = 42;
            numbers[1] = numbers.Length;
            numbers[2] = numbers[0] + numbers[1];
            numbers[numbers.Length - 1] = 99;


            foreach (int i in numbers)
            {
                Console.WriteLine(i);
            }
        }

        // Listing 5-3
        public static string GetCopyrightForType(object o)
        {
            Assembly asm = o.GetType().Assembly;
            var copyrightAttribute = (AssemblyCopyrightAttribute)
                asm.GetCustomAttributes(typeof(AssemblyCopyrightAttribute), true)[0];
            return copyrightAttribute.Copyright;
        }


        //// Kod umieszczony w komentarzach gdyż ilustruje błąd.
        //public static void IllegalUseOfArray()
        //{
        //    // Listing 5-4
        //    var values = new Complex[10];
        //    // Te wiersze spowodują błąd kompilatora
        //    values[0].Real = 10;
        //    values[0].Imaginary = 1;
        //}

        public static void ModifyingImmutableArrayElements()
        {
            // Listing 5-5
            var values = new Complex[10];
            values[0] = new Complex(10, 1);

            Console.WriteLine(values[0]);
        }
    }
}
